<?php
include('test.php');
include "kiteconnect.php";

$kite = new KiteConnect(KITE_KEY);
$content = trim(file_get_contents('token'));
$kite->setAccessToken(trim($content));

date_default_timezone_set("Asia/Kolkata");
$today = date("Y-m-d H:i:s");
$bankNiftyID = 260105;

$alertDatalive = '{"type" : "PE", "call" : "SELL"}';
$alertData = json_decode($alertDatalive, true);

$current_stock = $kite->getQuote([$bankNiftyID]);
$current_value = $current_stock[$bankNiftyID]->last_price;
$current_value = round($current_value / 100) * 100;

$type = $alertData['type'];
$call = $alertData['call'];

$beforeExpiry = [ 'Monday','Tuesday','Wednesday'];
$afterExpiry = ['Friday'];
$currThursday = ['Thursday'];

$nextThursdate = date("Y-m-d", strtotime('next Thursday'));
$lastThursdate = date("Y-m-d", strtotime('last thu of this month'));

$nextThursday = date("d", strtotime($nextThursdate));
$lastThursday = date("d", strtotime($lastThursdate));

$currentDay = date("l");
$currentDate = date("d");

// BANKNIFTY22AUG39500CE
// BANKNIFTY2281839500PE

// $currentDay = "Monday";

if(in_array($currentDay, $beforeExpiry)){
	if($nextThursday == $lastThursday){
		$nextExpiryDay = strtoupper(date("yM"));
	}else{
		$nextExpiryDay = strtoupper(date("ynj", strtotime($nextThursdate)));
	}
}

if(in_array($currentDay, $afterExpiry)){
	if($nextThursday == $lastThursday){
		$nextExpiryDay = strtoupper(date("yM"));
	}else{
		$nextExpiryDay = strtoupper(date("ynj", strtotime($nextThursdate)));
	}
}

if(in_array($currentDay, $currThursday)){
	if($currentDate == $lastThursday){
		$nextExpiryDay = strtoupper(date("yM"));
	}else{
		$nextExpiryDay = strtoupper(date("ynj", strtotime($today)));
	}
}

if($nextDate > $lastThursday){
    $nextDay = strtoupper($nextDay);
}

$nextExpiry = "BANKNIFTY{$nextExpiryDay}{$current_value}{$type}";
$next_stock_quote = $kite->getQuote(["NFO:".$nextExpiry]);
$next_last_price = $next_stock_quote["NFO:".$nextExpiry]->last_price;
$ins_token = $next_stock_quote["NFO:".$nextExpiry]->instrument_token;


if($type == "PE" && $call == "EXIT"){
	$insertAlertQry = "INSERT INTO ${tbname}alerts (type, order_call, status, created) VALUES ('{$type}', '{$call}', 0, '{$today}') ";
	mysqli_query($con, $insertAlertQry);
	$alert_id = mysqli_insert_id($con);

	$insertOrderQry = "INSERT INTO ${tbname}order (alert_id, ins_token, symbol, order_price, type, call_action, quantity, created) VALUES ('{$alert_id}', '{$ins_token}', '{$nextExpiry}', '{$next_last_price}', '{$type}', '{$call}', 25, '{$today}' ) ";
	mysqli_query($con, $insertOrderQry);
}

if($type == "CE" && $call == "EXIT"){
	$insertAlertQry = "INSERT INTO ${tbname}alerts (type, order_call, status, created) VALUES ('{$type}', '{$call}', 0, '{$today}') ";
	mysqli_query($con, $insertAlertQry);
	$alert_id = mysqli_insert_id($con);

	$insertOrderQry = "INSERT INTO ${tbname}order (alert_id, ins_token, symbol, order_price, type, call_action, quantity, created) VALUES ('{$alert_id}', '{$ins_token}', '{$nextExpiry}', '{$next_last_price}', '{$type}', '{$call}', 25, '{$today}' ) ";
	mysqli_query($con, $insertOrderQry);
}

if($type == "PE" && $call == "SELL"){
	$insertAlertQry = "INSERT INTO ${tbname}alerts (type, order_call, status, created) VALUES ('{$type}', '{$call}', 0, '{$today}') ";
	mysqli_query($con, $insertAlertQry);
	$alert_id = mysqli_insert_id($con);

	$insertOrderQry = "INSERT INTO ${tbname}order (alert_id, ins_token, symbol, order_price, type, call_action, quantity, created) VALUES ('{$alert_id}', '{$ins_token}', '{$nextExpiry}', '{$next_last_price}', '{$type}', '{$call}', 25, '{$today}' ) ";
	mysqli_query($con, $insertOrderQry);
}

if($type == "CE" && $call == "SELL"){
	$insertAlertQry = "INSERT INTO ${tbname}alerts (type, order_call, status, created) VALUES ('{$type}', '{$call}', 0, '{$today}') ";
	mysqli_query($con, $insertAlertQry);
	$alert_id = mysqli_insert_id($con);

	$insertOrderQry = "INSERT INTO ${tbname}order (alert_id, ins_token, symbol, order_price, type, call_action, quantity, created) VALUES ('{$alert_id}', '{$ins_token}', '{$nextExpiry}', '{$next_last_price}', '{$type}', '{$call}', 25, '{$today}' ) ";
	mysqli_query($con, $insertOrderQry);
}

?>