<?php
include "test.php";
include "kiteconnect.php";

date_default_timezone_set("Asia/Kolkata");
$today = date("Y-m-d H:i:s");
$todate = date("Y-m-d");
$currDay = date("l");

$finalSetting = $allsettings[$currDay];
extract($finalSetting);

$kite = new KiteConnect(KITE_KEY);
$content = file_get_contents('token');
$bankNiftyId = $symbol;
$kite->setAccessToken(trim($content));


// to check cur day and set day - days array
$closeDays = ["Saturday","Sunday"];
$thursDays = ["Thursday"];
$beforeExpiry = [ 'Monday','Tuesday','Wednesday'];
$afterExpiry = ['Friday'];
$currThursday = ['Thursday'];

$currDay = date("l");
$nextThursdate = date("Y-m-d", strtotime('next Thursday'));
$lastThursdate = date("Y-m-d", strtotime('last thu of this month'));
$openTime = strtotime("09:18:00");
$curToday = strtotime(date("H:i:s", strtotime($today)));
$nextThursday = date("d", strtotime($nextThursdate));
$lastThursday = date("d", strtotime($lastThursdate));
$currentDay = date("l");
$currentDate = date("d");
$currentMonthletter = str_split(date("M"));


if(in_array($currDay, $thursDays)){
    $closeTime = strtotime("15:00:00");
}else{
    $closeTime = strtotime("15:25:00");
}


if($curToday >= $closeTime){
    $openOrddb = "SELECT * FROM {$tbname}ce_orders_atm WHERE DATE(created) = '{$todate}' AND (status != 'COMPLETE' AND status != 'CANCELLED') ORDER BY id DESC";
    $resOrddb = mysqli_query($con, $openOrddb);
    
    if(mysqli_num_rows($resOrddb) > 0){
        $openOrds = [];
    	while($rowOrddb = mysqli_fetch_assoc($resOrddb)){
    	    if($rowOrddb['status'] !== $kite::STATUS_COMPLETE){
    	        $updateOrder = "UPDATE {$tbname}ce_orders_atm SET status = 'CANCELLED' WHERE order_id = '{$rowOrddb['order_id']}'";
    	        mysqli_query($con, $updateOrder);    
    	    }
    	}
    }
	echo "Market is closed, after time";
    exit;
}

if($openTime > $curToday){
	echo "Market is closed, before time";
    exit;
}

if(in_array($currDay, $closeDays)){
    echo "Market holiday";
    exit;
}


$current_stock = $kite->getQuote([$bankNiftyId]);
$current_value = $current_stock[$bankNiftyId]->last_price;

$qty = 0;

if(in_array($currentDay, $beforeExpiry)){
    $qty = $quantity*$lot;
	if($nextThursday == $lastThursday){
		$nextExpiryDay = strtoupper(date("yM"));
	}else{
        $nextDay = date("d", strtotime($nextThursdate));
        // $nextMonth = str_split(date("M", strtotime($nextThursdate)));
        $nextMonth = date("n", strtotime($nextThursdate));
        $nextYear = date("y", strtotime($nextThursdate));
		$nextExpiryDay = $nextYear.$nextMonth[0].$nextDay;
		// $nextExpiryDay = strtoupper(date("yMd", strtotime($nextThursdate)));
	}
}

if(in_array($currentDay, $afterExpiry)){
    $qty = $quantity*$lot;
    if($nextThursday == $lastThursday){
		$nextExpiryDay = strtoupper(date("yM"));
	}else{
        $nextDay = date("d", strtotime($nextThursdate));
        // $nextMonth = str_split(date("M", strtotime($nextThursdate)));
        $nextMonth = date("n", strtotime($nextThursdate));
        $nextYear = date("y", strtotime($nextThursdate));
		$nextExpiryDay = $nextYear.$nextMonth[0].$nextDay;
		// $nextExpiryDay = strtoupper(date("yMd", strtotime($nextThursdate)));
	}
}


if(in_array($currentDay, $currThursday)){
    $qty = $quantity*$lot;
	if($currentDate == $lastThursday){
		$nextExpiryDay = strtoupper(date("yM"));
	}else{
        $nextDay = date("d", strtotime($today));
        // $nextMonth = str_split(date("M", strtotime($today)));
        $nextMonth = date("n", strtotime($nextThursdate));
        $nextYear = date("y", strtotime($today));
		$nextExpiryDay = $nextYear.$nextMonth[0].$nextDay;
		// $nextExpiryDay = strtoupper(date("yMd", strtotime($today)));	
	}
}

/*
if($symbol === '260105'){
    $symbolName = 'BANKNIFTY';
    $current_value = round($current_value / 100) * 100;
}
if($symbol === '256265'){
    $symbolName = 'NIFTY';
    $current_value = round($current_value / 50) * 50;
}
*/

if($symbol === '260105'){
    $symbolName = 'BANKNIFTY';
    $current_value = round($current_stock[$bankNiftyId]->last_price / 100) * 100;
}
if($symbol === '256265'){
    $symbolName = 'NIFTY';
    $current_value = round($current_stock[$bankNiftyId]->last_price / 50) * 50;
}

$nextExpiryOption = "{$symbolName}{$nextExpiryDay}{$current_value}CE";

/*echo $nextExpiryOption;
echo "<br>";
echo $stoploss;
echo "<br>";
echo $target;
echo "<br>";
exit;*/
/* $stockPrice = $kite->getQuote("NFO:{$nextExpiryOption}");
$stockLastPrice = $stockPrice["NFO:{$nextExpiryOption}"]->last_price; */

function cancelOrders(){
	global $con, $tbname, $kite;
	$openOrddb = "SELECT * FROM {$tbname}ce_orders_atm WHERE (status != 'COMPLETE' AND status != 'CANCELLED') ";
	$resOrddb = mysqli_query($con, $openOrddb);
	while($rowOrddb = mysqli_fetch_assoc($resOrddb)){
		$order_id = $rowOrddb['order_id'];
        $kite->cancelOrder("regular", $order_id);
        $updateCancelOrder = "UPDATE {$tbname}ce_orders_atm SET status = 'CANCELLED' WHERE order_id = '{$order_id}'";
        mysqli_query($con, $updateCancelOrder);
	}
	sleep(5);
	makeOrders();
}

$openOrddb = "SELECT * FROM {$tbname}ce_orders_atm WHERE DATE(created) = '{$todate}' ORDER BY id desc LIMIT 3";
$resOrddb = mysqli_query($con, $openOrddb);

if(mysqli_num_rows($resOrddb) > 0){
    $openOrds = [];
	while($rowOrddb = mysqli_fetch_assoc($resOrddb)){
		$status = $rowOrddb['status'];
		if($status !== $kite::STATUS_COMPLETE){
			$openOrds[] = $rowOrddb['order_id'];
		}
	}
	
    if(count($openOrds) > 0){
        foreach ($openOrds as $orderKey => $orderid) {
            $orderHistory = $kite->getOrderHistory($orderid);
            $orderStatus = end($orderHistory);
            if($orderStatus->status === $kite::STATUS_COMPLETE){
                $updateOrder = "UPDATE {$tbname}ce_orders_atm SET status = 'COMPLETE' WHERE order_id = '{$orderid}'";
                mysqli_query($con, $updateOrder);
                cancelOrders();
            }
        }
    }else{
        makeOrders();
    }
}else{
    $marketArgs = [
		"tradingsymbol" => $nextExpiryOption,
		"exchange" => $exchange,
		"quantity" => (int) $qty,
		"transaction_type" => $kite::TRANSACTION_TYPE_SELL,
		"order_type" => $kite::ORDER_TYPE_MARKET,
		"product" => $kite::PRODUCT_MIS
	];

    try{
		$marketOrder = $kite->placeOrder("regular", $marketArgs);

        if($marketOrder !== NULL || $marketOrder !== ''){
            $insmarketOrder = "INSERT INTO {$tbname}ce_orders_atm (order_id, status, created) VALUES ('{$marketOrder->order_id}', 'COMPLETE', '{$today}')";
            mysqli_query($con, $insmarketOrder);

            sleep(5);
            $ordHistory = $kite->getOrderHistory($marketOrder->order_id);
            $lastOrder = end($ordHistory);
            $lastOrderPrice = $lastOrder->average_price;
            $tradingSymbol = $lastOrder->tradingsymbol;
            
            $sl_price = (float) $lastOrderPrice + (($lastOrderPrice*$stoploss)/100);
            $target_price = (float) $lastOrderPrice - (($lastOrderPrice*$target)/100);
            
            $sl_price = number_format($sl_price,1);
            $target_price = number_format($target_price,1);

            if($lastOrder->status === $kite::STATUS_COMPLETE){
                try{
                    $slArgs = [
                        "tradingsymbol" => $tradingSymbol,
                        "exchange" => $exchange,
                        "quantity" => (int) $qty,
                        "transaction_type" => $kite::TRANSACTION_TYPE_BUY,
                        "order_type" => $kite::ORDER_TYPE_SL,
                        "product" => $kite::PRODUCT_MIS,
                        "trigger_price" => (float) $sl_price,
                        "price" => (float) $sl_price,
                    ];

            		$slOrder = $kite->placeOrder("regular", $slArgs);
            
            		if($slOrder !== NULL || $slOrder !== ''){
            			$insslOrder = "INSERT INTO {$tbname}ce_orders_atm (order_id, status, created) VALUES ('{$slOrder->order_id}', 'TRIGGER PENDING', '{$today}')";
            			mysqli_query($con, $insslOrder);
            		}
            	}catch(Exception $error2){
            		print_r($error2);
            	}
            
            	try{
                    $targetArgs = [
                        "tradingsymbol" => $tradingSymbol,
                        "exchange" => $exchange,
                        "quantity" => (int) $qty,
                        "transaction_type" => $kite::TRANSACTION_TYPE_BUY,
                        "order_type" => $kite::ORDER_TYPE_LIMIT,
                        "product" => $kite::PRODUCT_MIS,
                        "price" => $target_price
                    ];

            		$targetOrder = $kite->placeOrder("regular", $targetArgs);
            
            		if($targetOrder !== NULL || $targetOrder !== ''){
            			$instargetOrder = "INSERT INTO {$tbname}ce_orders_atm (order_id, status, created) VALUES ('{$targetOrder->order_id}', 'OPEN', '{$today}')";
            			mysqli_query($con, $instargetOrder);
            		}
            	}catch(Exception $error3){
            		print_r($error3);
            	}
            }
        }
    }catch(Exception $error){
        echo "<pre>";
        print_r($error);
        echo "</pre>";
    }
}

function makeOrders(){
    global $con, $tbname, $exchange, $kite, $nextExpiryOption, $qty, $today, $stoploss, $target;

    $marketArgs = [
		"tradingsymbol" => $nextExpiryOption,
		"exchange" => $exchange,
		"quantity" => (int) $qty,
		"transaction_type" => $kite::TRANSACTION_TYPE_SELL,
		"order_type" => $kite::ORDER_TYPE_MARKET,
		"product" => $kite::PRODUCT_MIS
	];

    try{
		$marketOrder = $kite->placeOrder("regular", $marketArgs);

        if($marketOrder !== NULL || $marketOrder !== ''){
            $insmarketOrder = "INSERT INTO {$tbname}ce_orders_atm (order_id, status, created) VALUES ('{$marketOrder->order_id}', 'COMPLETE', '{$today}')";
            mysqli_query($con, $insmarketOrder);

            sleep(5);
            $ordHistory = $kite->getOrderHistory($marketOrder->order_id);
            $lastOrder = end($ordHistory);
            $lastOrderPrice = $lastOrder->average_price;
            $tradingSymbol = $lastOrder->tradingsymbol;
            
            $sl_price = (float) $lastOrderPrice + (($lastOrderPrice*$stoploss)/100);
            $target_price = (float) $lastOrderPrice - (($lastOrderPrice*$target)/100);
            
            $sl_price = number_format($sl_price,1);
            $target_price = number_format($target_price,1);

            if($lastOrder->status === $kite::STATUS_COMPLETE){
                try{
                    $slArgs = [
                        "tradingsymbol" => $tradingSymbol,
                        "exchange" => $exchange,
                        "quantity" => (int) $qty,
                        "transaction_type" => $kite::TRANSACTION_TYPE_BUY,
                        "order_type" => $kite::ORDER_TYPE_SL,
                        "product" => $kite::PRODUCT_MIS,
                        "trigger_price" => (float) $sl_price,
                        "price" => (float) $sl_price,
                    ];

            		$slOrder = $kite->placeOrder("regular", $slArgs);
            
            		if($slOrder !== NULL || $slOrder !== ''){
            			$insslOrder = "INSERT INTO {$tbname}ce_orders_atm (order_id, status, created) VALUES ('{$slOrder->order_id}', 'TRIGGER PENDING', '{$today}')";
            			mysqli_query($con, $insslOrder);
            		}
            	}catch(Exception $error2){
            		print_r($error2);
            	}
            
            	try{
                    $targetArgs = [
                        "tradingsymbol" => $tradingSymbol,
                        "exchange" => $exchange,
                        "quantity" => (int) $qty,
                        "transaction_type" => $kite::TRANSACTION_TYPE_BUY,
                        "order_type" => $kite::ORDER_TYPE_LIMIT,
                        "product" => $kite::PRODUCT_MIS,
                        "price" => $target_price
                    ];

            		$targetOrder = $kite->placeOrder("regular", $targetArgs);
            
            		if($targetOrder !== NULL || $targetOrder !== ''){
            			$instargetOrder = "INSERT INTO {$tbname}ce_orders_atm (order_id, status, created) VALUES ('{$targetOrder->order_id}', 'OPEN', '{$today}')";
            			mysqli_query($con, $instargetOrder);
            		}
            	}catch(Exception $error3){
            		print_r($error3);
            	}
            }
        }
    }catch(Exception $error){
        echo "<pre>";
        print_r($error);
        echo "</pre>";
    }
}
?>