<?php
include "test.php";
include "kiteconnect.php";

date_default_timezone_set("Asia/Kolkata");
$today = date("Y-m-d H:i:s");
$todate = date("Y-m-d");

$kite = new KiteConnect(KITE_KEY);
$content = file_get_contents('token');
$bankNiftyId = 260105;
$kite->setAccessToken(trim($content));

$currDay = date("l");
$closeDays = ["Saturday","Sunday"];
$thursDays = ["Thursday"];
$beforeExpiry = [ 'Monday','Tuesday','Wednesday'];
$afterExpiry = ['Friday'];
$currThursday = ['Thursday'];

$minTime = strtotime(date("Y-m-d"). " 09:00:00");
$maxTime = strtotime(date("Y-m-d"). " 17:05:00");
$orderOpentime = strtotime(date("Y-m-d"). " 09:18:00");
$orderClosetime = strtotime(date("Y-m-d"). " 15:25:00");
$nextThursdate = date("Y-m-d", strtotime('next Thursday'));
$lastThursdate = date("Y-m-d", strtotime('last thu of this month'));
$openTime = strtotime("09:18:00");
$closeTime = strtotime("15:25:00");
$curToday = strtotime(date("H:i:s",strtotime($today)));

if($curToday >= $closeTime){
    
    $openOrddb = "SELECT * FROM {$tbname}ce_orders WHERE DATE(created) = '{$todate}' AND (status != 'COMPLETE' AND status != 'CANCELLED') ORDER BY created desc";
    $resOrddb = mysqli_query($con, $openOrddb);
    
    if(mysqli_num_rows($resOrddb) > 0){
        $openOrds = [];
    	while($rowOrddb = mysqli_fetch_assoc($resOrddb)){
    	    if($rowOrddb['status'] !== 'COMPLETE'){
    	        $updateOrder = "UPDATE {$tbname}ce_orders SET status = 'CANCELLED' WHERE order_id = '{$rowOrddb['order_id']}'";
    	        mysqli_query($con, $updateOrder);    
    	    }
    	   // $kite->deleteGTT($rowOrddb['order_id']);
    	}
    }
    
	echo "Market is closed, after time";
    exit;
}

if(in_array($currDay, $closeDays)){
    echo "Market holiday";
    exit;
}


if($openTime > $curToday){
	echo "Market is closed, before time";
    exit;
}

$nextThursday = date("d", strtotime($nextThursdate));
$lastThursday = date("d", strtotime($lastThursdate));

$currentDay = date("l");
$currentDate = date("d");
$currentMonthletter = str_split(date("M"));

$current_stock = $kite->getQuote([$bankNiftyId]);
$current_value = $current_stock[$bankNiftyId]->last_price;
$current_value = round($current_value / 100) * 100;
$qty = 0;

if(in_array($currentDay, $beforeExpiry)){
    $qty = 300;
    // $qty = 25;
	if($nextThursday == $lastThursday){
		$nextExpiryDay = strtoupper(date("yM"));
	}else{
        $nextDay = date("d", strtotime($nextThursdate));
        $nextMonth = str_split(date("M", strtotime($nextThursdate)));
        $nextYear = date("y", strtotime($nextThursdate));
		$nextExpiryDay = $nextYear.$nextMonth[0].$nextDay;
		// $nextExpiryDay = strtoupper(date("yMd", strtotime($nextThursdate)));
	}
}

if(in_array($currentDay, $afterExpiry)){
    $qty = 300;
    // $qty = 25;
    if($nextThursday == $lastThursday){
		$nextExpiryDay = strtoupper(date("yM"));
	}else{
        $nextDay = date("d", strtotime($nextThursdate));
        $nextMonth = str_split(date("M", strtotime($nextThursdate)));
        $nextYear = date("y", strtotime($nextThursdate));
		$nextExpiryDay = $nextYear.$nextMonth[0].$nextDay;
		// $nextExpiryDay = strtoupper(date("yMd", strtotime($nextThursdate)));
	}
}

if(in_array($currentDay, $currThursday)){
    $qty = 250;
    // $qty = 25;
	if($currentDate == $lastThursday){
		$nextExpiryDay = strtoupper(date("yM"));
	}else{
        $nextDay = date("d", strtotime($today));
        $nextMonth = str_split(date("M", strtotime($today)));
        $nextYear = date("y", strtotime($today));
		$nextExpiryDay = $nextYear.$nextMonth[0].$nextDay;
		// $nextExpiryDay = strtoupper(date("yMd", strtotime($today)));	
	}
}

$futureCEIns = "BANKNIFTY{$nextExpiryDay}{$current_value}CE";
// $futureCEIns = "BANKNIFTY22O0639400PE";

$symbols = ["NFO:{$futureCEIns}"];
$current_stocks = $kite->getQuote($symbols);
$ce_last_price = $current_stocks["NFO:{$futureCEIns}"]->last_price;


/* echo "<pre>";
print_r($current_stocks);
echo "</pre>";
exit; */

/*
$ordHis = $kite->getOrderHistory(221013203316456);
$lastOrd = end($ordHis);

$sl_perct = 70;
$target_perct = 50;

$lastOrderPrice = $lastOrd->average_price;
$sl_price = (float) $lastOrderPrice + (($lastOrderPrice*$sl_perct)/100);
$target_price = (float) $lastOrderPrice - (($lastOrderPrice*$target_perct)/100);

$sl_price = number_format($sl_price,1);
$target_price = number_format($target_price,1);
$exchange = "NFO";
$product_type = "MIS";
$tradingSymbol = $lastOrd->tradingsymbol;

sleep(2);

$slArgs = [
	"tradingsymbol" => $tradingSymbol,
	"exchange" => $exchange,
	"quantity" => (int) $qty,
	"transaction_type" => $kite::TRANSACTION_TYPE_BUY,
	"order_type" => $kite::ORDER_TYPE_SL,
	"product" => $kite::PRODUCT_MIS,
	"trigger_price" => (float) $sl_price,
	"price" => (float) $sl_price,
];

$targetArgs = [
	"tradingsymbol" => $tradingSymbol,
	"exchange" => $exchange,
	"quantity" => (int) $qty,
	"transaction_type" => $kite::TRANSACTION_TYPE_BUY,
	"order_type" => $kite::ORDER_TYPE_LIMIT,
	"product" => $kite::PRODUCT_MIS,
	"price" => $target_price
];

if($lastOrd->status === $kite::STATUS_COMPLETE){
    
    try{
		$slOrder = $kite->placeOrder("regular", $slArgs);

		if($slOrder !== NULL || $slOrder !== ''){
			$insslOrder = "INSERT INTO {$tbname}pe_orders (order_id, status, created) VALUES ('{$slOrder->order_id}', 'TRIGGER PENDING', '{$today}')";
			echo "<br>";
			echo $insslOrder;
			echo "<pre>";
			print_r($slOrder);
			echo "</pre>";
			mysqli_query($con, $insslOrder);
		}
	}catch(Exception $error2){
		print_r($error2);
	}

	try{
		$targetOrder = $kite->placeOrder("regular", $targetArgs);

		if($targetOrder !== NULL || $targetOrder !== ''){
			$instargetOrder = "INSERT INTO {$tbname}pe_orders (order_id, status, created) VALUES ('{$targetOrder->order_id}', 'OPEN', '{$today}')";
			echo "<br>";
			echo $instargetOrder;
			echo "<pre>";
			print_r($targetOrder);
			echo "</pre>";
			mysqli_query($con, $instargetOrder);
		}
	}catch(Exception $error3){
		print_r($error3);
	}
}

exit;
*/

function cancelOrders(){
	global $con, $tbname, $kite;
	$openOrddb = "SELECT * FROM {$tbname}ce_orders ORDER BY id desc LIMIT 3";
	$resOrddb = mysqli_query($con, $openOrddb);
	while($rowOrddb = mysqli_fetch_assoc($resOrddb)){
		$order_id = $rowOrddb['order_id'];
		$status = $rowOrddb['status'];
		if($status !== "COMPLETE"){
			$kite->cancelOrder("regular", $order_id);
			$updateCancelOrder = "UPDATE {$tbname}ce_orders SET status = 'CANCELLED' WHERE order_id = '{$order_id}'";
			mysqli_query($con, $updateCancelOrder);
		}
	}
	sleep(2);
	makeOrders();
}

$openOrddb = "SELECT * FROM {$tbname}ce_orders WHERE DATE(created) = '{$todate}' ORDER BY created desc LIMIT 3";
$resOrddb = mysqli_query($con, $openOrddb);

if(mysqli_num_rows($resOrddb) > 0){
    $openOrds = [];
	while($rowOrddb = mysqli_fetch_assoc($resOrddb)){
		$status = $rowOrddb['status'];
		if($status !== "COMPLETE"){
			$openOrds[] = $rowOrddb['order_id'];
		}
	}
	
	if(count($openOrds) > 0){
	    foreach ($openOrds as $orderKey => $orderid) {
    		$orderHistory = $kite->getOrderHistory($orderid);
    		$orderStatus = end($orderHistory);
    		if($orderStatus->status === 'COMPLETE'){
    			$updateOrder = "UPDATE {$tbname}ce_orders SET status = 'COMPLETE' WHERE order_id = '{$orderid}'";
    			mysqli_query($con, $updateOrder);
    			cancelOrders();
    		}
    	}
	}else{
	    makeOrders();
	}
	
}else{
    $sl_perct = 70;
	$target_perct = 50;

	$exchange = "NFO";
	$quantity = 25;
	$product_type = "MIS";

	$marketArgs = [
		"tradingsymbol" => $futureCEIns,
		"exchange" => $exchange,
		"quantity" => (int) $qty,
		"transaction_type" => $kite::TRANSACTION_TYPE_SELL,
		"order_type" => $kite::ORDER_TYPE_MARKET,
		"product" => $kite::PRODUCT_MIS
	];
	
    try{
		$marketOrder = $kite->placeOrder("regular", $marketArgs);

		if($marketOrder !== NULL || $marketOrder !== ''){
			$insmarketOrder = "INSERT INTO {$tbname}ce_orders (order_id, status, created) VALUES ('{$marketOrder->order_id}', 'COMPLETE', '{$today}')";

			echo "<br>";
			echo $insmarketOrder;
			echo "<pre>";
			print_r($marketOrder);
			echo "</pre>";
			mysqli_query($con, $insmarketOrder);
			
			$ordHis = $kite->getOrderHistory($marketOrder->order_id);
            $lastOrd = end($ordHis);
            $lastOrderPrice = $lastOrd->average_price;
            $tradingSymbol = $lastOrd->tradingsymbol;
            $exchange = "NFO";
            $product_type = "MIS";
            
            sleep(5);
            
            $sl_perct = 70;
            $target_perct = 50;
            
            $sl_price = (float) $lastOrderPrice + (($lastOrderPrice*$sl_perct)/100);
            $target_price = (float) $lastOrderPrice - (($lastOrderPrice*$target_perct)/100);
            
            $sl_price = number_format($sl_price,1);
            $target_price = number_format($target_price,1);
            
            $slArgs = [
            	"tradingsymbol" => $tradingSymbol,
            	"exchange" => $exchange,
            	"quantity" => (int) $qty,
            	"transaction_type" => $kite::TRANSACTION_TYPE_BUY,
            	"order_type" => $kite::ORDER_TYPE_SL,
            	"product" => $kite::PRODUCT_MIS,
            	"trigger_price" => (float) $sl_price,
            	"price" => (float) $sl_price,
            ];
            
            $targetArgs = [
            	"tradingsymbol" => $tradingSymbol,
            	"exchange" => $exchange,
            	"quantity" => (int) $qty,
            	"transaction_type" => $kite::TRANSACTION_TYPE_BUY,
            	"order_type" => $kite::ORDER_TYPE_LIMIT,
            	"product" => $kite::PRODUCT_MIS,
            	"price" => $target_price
            ];
            
            if($lastOrd->status === $kite::STATUS_COMPLETE){
                
                try{
            		$slOrder = $kite->placeOrder("regular", $slArgs);
            
            		if($slOrder !== NULL || $slOrder !== ''){
            			$insslOrder = "INSERT INTO {$tbname}ce_orders (order_id, status, created) VALUES ('{$slOrder->order_id}', 'TRIGGER PENDING', '{$today}')";
            			echo "<br>";
            			echo $insslOrder;
            			echo "<pre>";
            			print_r($slOrder);
            			echo "</pre>";
            			mysqli_query($con, $insslOrder);
            		}
            	}catch(Exception $error2){
            		print_r($error2);
            	}
            
            	try{
            		$targetOrder = $kite->placeOrder("regular", $targetArgs);
            
            		if($targetOrder !== NULL || $targetOrder !== ''){
            			$instargetOrder = "INSERT INTO {$tbname}ce_orders (order_id, status, created) VALUES ('{$targetOrder->order_id}', 'OPEN', '{$today}')";
            			echo "<br>";
            			echo $instargetOrder;
            			echo "<pre>";
            			print_r($targetOrder);
            			echo "</pre>";
            			mysqli_query($con, $instargetOrder);
            		}
            	}catch(Exception $error3){
            		print_r($error3);
            	}
            }
		}
	}catch(Exception $error){
		print_r($error);
	}

}
// exit;

function makeOrders()
{
    global $con, $tbname, $kite, $ce_last_price, $futureCEIns, $qty, $today;

    $sl_perct = 70;
	$target_perct = 50;
    /*$sl_perct = 5;
	$target_perct = 5;*/

	/*$sl_price = (float) $ce_last_price + (($ce_last_price*$sl_perct)/100);
	$target_price = (float) $ce_last_price - (($ce_last_price*$target_perct)/100);*/
	
	$exchange = "NFO";
// 	$quantity = 25;
	$product_type = "MIS";

	/*$sl_price = number_format($sl_price,1);
	$target_price = number_format($target_price,1);*/

    $marketArgs = [
		"tradingsymbol" => $futureCEIns,
		"exchange" => $exchange,
		"quantity" => (int) $qty,
		"transaction_type" => $kite::TRANSACTION_TYPE_SELL,
		"order_type" => $kite::ORDER_TYPE_MARKET,
		"product" => $kite::PRODUCT_MIS
	];
    
    /*
    $slArgs = [
		"tradingsymbol" => $futureCEIns,
        "exchange" => $exchange,
        "transaction_type" => $kite::TRANSACTION_TYPE_BUY,
        "quantity" => (int) $qty,
        // "product" => $kite::PRODUCT_NRML,
        "product" => $kite::PRODUCT_MIS,
        "order_type" => $kite::ORDER_TYPE_LIMIT,
        "price" => (float) $sl_price
	];

	$targetArgs = [
		"tradingsymbol" => $futureCEIns,
        "exchange" => $exchange,
        "transaction_type" => $kite::TRANSACTION_TYPE_BUY,
        "quantity" => (int) $qty,
        "product" => $kite::PRODUCT_MIS,
        // "product" => $kite::PRODUCT_NRML,
        "order_type" => $kite::ORDER_TYPE_LIMIT,
        "price" => (float) $target_price
	];
	*/

    try{
		$marketOrder = $kite->placeOrder("regular", $marketArgs);

		if($marketOrder !== NULL || $marketOrder !== ''){
			$insmarketOrder = "INSERT INTO {$tbname}ce_orders (order_id, status, created) VALUES ('{$marketOrder->order_id}', 'COMPLETE', '{$today}')";

			echo "<br>";
			echo $insmarketOrder;
			echo "<pre>";
			print_r($marketOrder);
			echo "</pre>";
			mysqli_query($con, $insmarketOrder);
			sleep(5);
			
			$ordHis = $kite->getOrderHistory($marketOrder->order_id);
            $lastOrd = end($ordHis);
            $lastOrderPrice = $lastOrd->average_price;
            $tradingSymbol = $lastOrd->tradingsymbol;
            $exchange = "NFO";
            $product_type = "MIS";
            
            $sl_perct = 70;
            $target_perct = 50;
            
            $sl_price = (float) $lastOrderPrice + (($lastOrderPrice*$sl_perct)/100);
            $target_price = (float) $lastOrderPrice - (($lastOrderPrice*$target_perct)/100);
            
            $sl_price = number_format($sl_price,1);
            $target_price = number_format($target_price,1);
            
            $slArgs = [
            	"tradingsymbol" => $tradingSymbol,
            	"exchange" => $exchange,
            	"quantity" => (int) $qty,
            	"transaction_type" => $kite::TRANSACTION_TYPE_BUY,
            	"order_type" => $kite::ORDER_TYPE_SL,
            	"product" => $kite::PRODUCT_MIS,
            	"trigger_price" => (float) $sl_price,
            	"price" => (float) $sl_price,
            ];
            
            $targetArgs = [
            	"tradingsymbol" => $tradingSymbol,
            	"exchange" => $exchange,
            	"quantity" => (int) $qty,
            	"transaction_type" => $kite::TRANSACTION_TYPE_BUY,
            	"order_type" => $kite::ORDER_TYPE_LIMIT,
            	"product" => $kite::PRODUCT_MIS,
            	"price" => $target_price
            ];
            
            if($lastOrd->status === $kite::STATUS_COMPLETE){
                
                try{
            		$slOrder = $kite->placeOrder("regular", $slArgs);
            
            		if($slOrder !== NULL || $slOrder !== ''){
            			$insslOrder = "INSERT INTO {$tbname}ce_orders (order_id, status, created) VALUES ('{$slOrder->order_id}', 'TRIGGER PENDING', '{$today}')";
            			echo "<br>";
            			echo $insslOrder;
            			echo "<pre>";
            			print_r($slOrder);
            			echo "</pre>";
            			mysqli_query($con, $insslOrder);
            		}
            	}catch(Exception $error2){
            		print_r($error2);
            	}
            
            	try{
            		$targetOrder = $kite->placeOrder("regular", $targetArgs);
            
            		if($targetOrder !== NULL || $targetOrder !== ''){
            			$instargetOrder = "INSERT INTO {$tbname}ce_orders (order_id, status, created) VALUES ('{$targetOrder->order_id}', 'OPEN', '{$today}')";
            			echo "<br>";
            			echo $instargetOrder;
            			echo "<pre>";
            			print_r($targetOrder);
            			echo "</pre>";
            			mysqli_query($con, $instargetOrder);
            		}
            	}catch(Exception $error3){
            		print_r($error3);
            	}
            }
		}
	}catch(Exception $error){
		print_r($error);
	}
}
?>
<script>
    setTimeout(() => {
        // location.reload();
    }, 2000);
</script>